//  Copyright (c)2015-2017, HuaRay Technology CO.LTD.
//  All Rights Reserved.

#ifndef __MVLOG_H__
#define __MVLOG_H__

#define MVLOG4CPP

#ifdef MVLOG4CPP
#       if defined(_MSC_VER) || defined(__BORLANDC__) || defined(__MINGW32__)
#           define MVLOG_EXPORT __declspec(dllexport)
#               else
#           define MVLOG_EXPORT
#               endif 
#else
#       if defined(_MSC_VER) || defined(__BORLANDC__) || defined(__MINGW32__)
#           define MVLOG_EXPORT __declspec(dllimport)
#               else
#           define MVLOG_EXPORT
#               endif 
#endif


/// ־CatalogȱʡrootʾָΪģ飬ڰļǰ
/// root ȱʡӦļģlog4cpp.category.mvsdk
/// infra infraģ飬Ӧļģlog4cpp.category.mvsdk.infra
/// net : ģ飬Ӧļģlog4cpp.category.mvsdk.net
/// gic GenICamش룬Ӧļģlog4cpp.category.mvsdk.gic
/// gtl GigEU3VCLش룬Ӧļģlog4cpp.category.mvsdk.gtl
/// api ڶinterfaceCAPIش룬Ӧļģlog4cpp.category.mvsdk.api
#ifndef MVLOG_CAT_NAME
#define MVLOG_CAT_NAME mvsdk
#endif

#define MVLOG_GET_LOGGER( cat_name ) MVLOG_GET_LOGGER_2( cat_name )
#define MVLOG_GET_LOGGER_2( cat_name ) MVlog4cpp::CMvLog::Logger_ ## cat_name ()

#define MVLOG_LEVEL_FATAL   0
#define MVLOG_LEVEL_ERROR   300
#define MVLOG_LEVEL_WARN    400
#define MVLOG_LEVEL_INFO    700
#define MVLOG_LEVEL_DEBUG   800

#define MVLOG_FATAL( fmt, ... )  MVLOG_PRINTLOG( MVLOG_LEVEL_FATAL, "FATAL", fmt, ##__VA_ARGS__ )
#define MVLOG_ERROR( fmt, ... )  MVLOG_PRINTLOG( MVLOG_LEVEL_ERROR, "ERROR", fmt, ##__VA_ARGS__ )
#define MVLOG_WARN( fmt, ... )  MVLOG_PRINTLOG( MVLOG_LEVEL_WARN, "WARN", fmt, ##__VA_ARGS__ )
#define MVLOG_INFO( fmt, ... )  MVLOG_PRINTLOG( MVLOG_LEVEL_INFO, "INFO", fmt, ##__VA_ARGS__ )
#define MVLOG_DEBUG( fmt, ... )  MVLOG_PRINTLOG( MVLOG_LEVEL_DEBUG, "DEBUG", fmt, ##__VA_ARGS__ )

#define MVLOG_DEBUG_IS_ENABLED()	MVlog4cpp::CMvLog::isLevelEnabled(MVLOG_GET_LOGGER(MVLOG_CAT_NAME), MVLOG_LEVEL_DEBUG)

#define MVLOG_PRINTLOG( level, level_str, fmt, ... ) \
	if((level != MVLOG_LEVEL_DEBUG) || MVLOG_DEBUG_IS_ENABLED()) \
	{ MVLOG_LOGGER_PRINTLOG(MVLOG_GET_LOGGER(MVLOG_CAT_NAME), level, level_str, fmt, ##__VA_ARGS__);}

#ifdef _WIN32

#include <windows.h>

#define MVLOG_LOGGER_PRINTLOG( logger, level, level_str, fmt, ... ) \
    do { \
        const char * mvlog__pfile = strrchr( __FILE__, '\\' ); \
        if( mvlog__pfile == NULL ) \
            mvlog__pfile = strrchr( __FILE__, '/' ); \
        if( mvlog__pfile == NULL ) \
            mvlog__pfile = __FILE__; \
                else \
            mvlog__pfile += 1; \
        const char * mvlog__pfunc = strrchr( __FUNCTION__, ':' ); \
        if( mvlog__pfunc == NULL ) \
            mvlog__pfunc = __FUNCTION__; \
                else \
            mvlog__pfunc += 1; \
        MVlog4cpp::CMvLog::Log( logger, level, "[%s(%d) %s] " fmt, \
             mvlog__pfile, __LINE__, mvlog__pfunc, ##__VA_ARGS__ ); \
        } while( 0 )

#else

#include <sys/time.h>
#include <time.h>

#define MVLOG_LOGGER_PRINTLOG( logger, level, level_str, fmt, ... ) \
    do { \
        const char * mvlog__pfile = strrchr( __FILE__, '\\' ); \
        if( mvlog__pfile == NULL ) \
            mvlog__pfile = strrchr( __FILE__, '/' ); \
        if( mvlog__pfile == NULL ) \
            mvlog__pfile = __FILE__; \
        else \
            mvlog__pfile += 1; \
        const char * mvlog__pfunc = strrchr( __FUNCTION__, ':' ); \
        if( mvlog__pfunc == NULL ) \
            mvlog__pfunc = __FUNCTION__; \
        else \
            mvlog__pfunc += 1; \
        MVlog4cpp::CMvLog::Log( logger, level, "[%s(%d) %s] " fmt, \
             mvlog__pfile, __LINE__, mvlog__pfunc, ##__VA_ARGS__ ); \
    } while( 0 )


#endif

namespace MVlog4cpp{

class Category;
class MVLOG_EXPORT CMvLog
{
public:
    static bool LoadConfig(const char * fname);
    static void LoadDefault();

    static void Log(Category * logger, int level, const char * fmt, ... );

	static bool isLevelEnabled(Category * logger, int level);

    static Category * Logger_mvsdk();
    static Category * Logger_camclient();

	static bool isConfigloaded();
};

} // namespace MVLog4cpp

#endif //__MVLOG_H__
