//  Copyright (c)2015-2017, HuaRay Technology CO.LTD.
//  All Rights Reserved.

#define MVLOG_CAT_NAME mvsdk
#include "MVLog/MVLog.h"
#include <fstream>

#ifdef DEBUG
#undef DEBUG
#endif // ifdef DEBUG

#include <log4cpp/Category.hh>
#include <log4cpp/PropertyConfigurator.hh>
#include <log4cpp/Configurator.hh>

#include <log4cpp/DailyRollingFileAppender.hh>
#include <log4cpp/PatternLayout.hh>
#include <log4cpp/Priority.hh>

#include <time.h>
#include <sstream>
#include <iomanip>
#include <cstdlib>

#ifndef WIN32
#include <unistd.h>   // unlink()
#endif

#define DEFAULT_PROPERTY_FILENAME "SDKLOG_default.properties"

using namespace std;

namespace MVlog4cpp{

#define IMPLEMENT_MVLOG_LOGGER( name ) \
    static MVlog4cpp::Category * s_logger_ ## name = NULL; \
    MVlog4cpp::Category * CMvLog::Logger_ ## name () \
    { \
        if( s_logger_ ## name == NULL ) \
        { \
            std::string cat_name = #name ; \
            if( cat_name == "mvsdk.root" ) \
                cat_name = "mvsdk"; \
            s_logger_ ## name = & MVlog4cpp::Category::getInstance( cat_name ); \
        } \
        return s_logger_ ## name ; \
    }

IMPLEMENT_MVLOG_LOGGER(mvsdk)
IMPLEMENT_MVLOG_LOGGER(camclient)

bool static fileLoadedFlag = false;

// ·log4cppļ
bool CMvLog::LoadConfig(const char * fname)
{
    // ȡconfigļ޸filename
    try
    {
		//μ
		fileLoadedFlag = true;
#ifdef WIN32
		char moduleFileName[MAX_PATH] = { 0 };
		if ((int)GetModuleFileName(NULL, moduleFileName, MAX_PATH) <= 0)
		{
			return false;
		}
		std::string strTemp = moduleFileName;
		size_t pos = strTemp.rfind("\\", strTemp.length());
		std::string strFile = strTemp.substr(0, pos + 1);
		strFile = strFile.append(fname);
		MVlog4cpp::PropertyConfigurator::configure(std::string(strFile));
#elif defined (__ANDROID__)
		//android/data/data/
		char readBuffer[250];
		memset(readBuffer, 0, sizeof(readBuffer));
		do
		{
			std::ostringstream command_s;
			command_s << "cat /proc/" << getpid() << "/cmdline" << std::ends;
			FILE *file_read = popen(command_s.str().c_str(), "r");
			if(file_read == NULL)
			{
				break;
			}

			if (fread(readBuffer, sizeof(char), sizeof(readBuffer), file_read) == 0)
			{
				pclose(file_read);
				break;
			}
			pclose(file_read);
		}while (false);

		std::string strFile = "/data/data/";
		strFile.append(std::string(readBuffer)).append("/");

		//Ƿjavaûа,̶λ/data/local/tmp/MVSDK/ȡļ
		if((strFile.length() == 0) || (access(strFile.c_str(), 0) < 0))
		{
			strFile = std::string("/data/local/tmp/MVSDK/");
		}

		strFile.append(fname);
		MVlog4cpp::PropertyConfigurator::configure(std::string(strFile));
#else
		char moduleFileName[260] = { 0 };
		size_t len = 260;
		int rsltLen = (int)readlink("/proc/self/exe", moduleFileName, len);
		if (rsltLen <= 0)
		{
			return false;
		}

		moduleFileName[rsltLen] = '\0';

		std::string strTemp = moduleFileName;
		size_t pos = strTemp.rfind("/", strTemp.length());
		std::string strFile = strTemp.substr(0, pos + 1);
		strFile = strFile.append(fname);

		MVlog4cpp::PropertyConfigurator::configure(std::string(strFile));
#endif
    }
    catch (MVlog4cpp::ConfigureFailure& f)
    {
        //std::cout << "load configuration failed : " << f.what() << std::endl;
        return false;
    }

    return true;
}

// Ĭ
void CMvLog::LoadDefault()
{
	//μ
	fileLoadedFlag = true;
    std::string strFile("");
#ifdef WIN32
    // write config file to local
    char moduleFileName[MAX_PATH] = { 0 };
	if ((int)GetModuleFileName(NULL, moduleFileName, MAX_PATH) <= 0)
	{
		return;
	}

    strFile = moduleFileName;
	size_t pos = strFile.rfind("\\", strFile.length());
    std::string strTemp = strFile.substr(0, pos + 1);
	strFile = strTemp + DEFAULT_PROPERTY_FILENAME;

#elif defined (__ANDROID__)
    //android/data/data/
	do
	{
		std::ostringstream command_s;
		command_s << "cat /proc/" << getpid() << "/cmdline" << std::ends;
		char readBuffer[250];
		memset(readBuffer, 0, sizeof(readBuffer));
		FILE *file_read = popen(command_s.str().c_str(), "r");
		if(file_read == NULL)
		{
			break;
		}

		if(fread(readBuffer, sizeof(char), sizeof(readBuffer), file_read) == 0)
		{
			pclose(file_read);
			break;
		}
		pclose(file_read);

		strFile.append("/data/data/").append(std::string(readBuffer)).append("/");
	}while(false);

	//Ƿjavaûа,д̶λ/data/local/tmp/MVSDK/
	if((strFile.length() == 0) || (access(strFile.c_str(), 0) < 0))
	{
		strFile = std::string("/data/local/tmp/MVSDK/");
		(void)mkdir(strFile.c_str(), (mode_t)0777);
	}

	strFile.append(DEFAULT_PROPERTY_FILENAME);
#else
    //linux
	char moduleFileName[260] = { 0 };
	size_t len = 260;
	int rsltLen = (int)readlink("/proc/self/exe", moduleFileName, len);
	if(rsltLen <= 0)
	{
		return;
	}

	moduleFileName[rsltLen] = '\0';
	strFile = moduleFileName;
	size_t pos = strFile.rfind("/", strFile.length());
	std::string strTemp = strFile.substr(0, pos + 1);
	strFile = strTemp + DEFAULT_PROPERTY_FILENAME;
#endif

    std::ofstream outFile(strFile.c_str(), std::ios::out);
    if (!outFile)
    {
        return;
    }

	// root setting
	outFile << "# ======================="   << std::endl;
	outFile << "#  root Setting"             << std::endl;
	outFile << "# ======================="   << std::endl;
	outFile << "log4cpp.rootCategory = INFO" << std::endl;
	outFile << "" << std::endl;

	// mvsdk setting
	outFile << "# ======================="                                                                    << std::endl;
	outFile << "#  SDK Log Setting"                                                                           << std::endl;
	outFile << "# ======================="                                                                    << std::endl;
	outFile << "log4cpp.category.mvsdk = INFO, a_mvsdk"                                                       << std::endl;
	outFile << "log4cpp.appender.a_mvsdk = DailyRollingFileAppender"                                          << std::endl;
	outFile << "log4cpp.appender.a_mvsdk.fileName = MVSDK.log"                                                << std::endl;
	outFile << "log4cpp.appender.a_mvsdk.layout = org.apache.log4cpp.PatternLayout"                           << std::endl;
	outFile << "log4cpp.appender.a_mvsdk.layout.ConversionPattern = %d{%Y-%m-%d %H:%M:%S.%l} %p [tid:%t]%m%n" << std::endl;
	outFile << "log4cpp.appender.a_mvsdk.maxDaysKeep = 5"                                                     << std::endl;
	outFile << "" << std::endl;

	// CamClient setting
	outFile << "# ======================="                                                                         << std::endl;
	outFile << "#  CamClient Log Setting"                                                                          << std::endl;
	outFile << "# ======================="                                                                         << std::endl;
	outFile << "#log4cpp.category.camclient = INFO, a_camclient"                                                   << std::endl;
	outFile << "#log4cpp.appender.a_camclient = DailyRollingFileAppender"                                          << std::endl;
	outFile << "#log4cpp.appender.a_camclient.fileName = CamClient.log"                                            << std::endl;
	outFile << "#log4cpp.appender.a_camclient.layout = org.apache.log4cpp.PatternLayout"                           << std::endl;
	outFile << "#log4cpp.appender.a_camclient.layout.ConversionPattern = %d{%Y-%m-%d %H:%M:%S.%l} %p [tid:%t]%m%n" << std::endl;
	outFile << "#log4cpp.appender.a_camclient.maxDaysKeep = 5"                                                     << std::endl;
	outFile << "" << std::endl;

    outFile.close();

    // load config
    try
    {
        MVlog4cpp::PropertyConfigurator::configure(std::string(strFile));
    }
    catch (MVlog4cpp::ConfigureFailure& f)
    {
        //std::cout << "load configuration failed : " << f.what() << std::endl;
    }

    return;
}

void CMvLog::Log(MVlog4cpp::Category * logger, int level, const char * fmt, ...)
{
    MVlog4cpp::Priority::Value pri = MVlog4cpp::Priority::DEBUG;
    if (level >= MVLOG_LEVEL_DEBUG)
        pri = MVlog4cpp::Priority::DEBUG;
    else if (level >= MVLOG_LEVEL_INFO)
        pri = MVlog4cpp::Priority::INFO;
    else if (level >= MVLOG_LEVEL_WARN)
        pri = MVlog4cpp::Priority::WARN;
    else if (level >= MVLOG_LEVEL_ERROR)
        pri = MVlog4cpp::Priority::ERROR;
    else if (level >= MVLOG_LEVEL_FATAL)
        pri = MVlog4cpp::Priority::FATAL;

    va_list va;
    va_start(va, fmt);
    logger->logva(pri, fmt, va);
    va_end(va);
    return;
}

bool CMvLog::isLevelEnabled(MVlog4cpp::Category * logger, int level)
{
	MVlog4cpp::Priority::Value pri = MVlog4cpp::Priority::DEBUG;
	if (level >= MVLOG_LEVEL_DEBUG)
		pri = MVlog4cpp::Priority::DEBUG;
	else if (level >= MVLOG_LEVEL_INFO)
		pri = MVlog4cpp::Priority::INFO;
	else if (level >= MVLOG_LEVEL_WARN)
		pri = MVlog4cpp::Priority::WARN;
	else if (level >= MVLOG_LEVEL_ERROR)
		pri = MVlog4cpp::Priority::ERROR;
	else if (level >= MVLOG_LEVEL_FATAL)
		pri = MVlog4cpp::Priority::FATAL;

	return logger->isPriorityEnabled(pri);
}

//жǷٴμ
bool CMvLog::isConfigloaded()
{
	return fileLoadedFlag;
}

} // namespace MVLog4cpp
